***********************************************************************

6/13/11: FIRST VERSION CREATED.  THIS PROGRAM CREATES FOODSTAMPS VAR FOR
1984, BECAUSE THE SUMMARY VARIABLE IS NOT AVAILABLE UNTIL 1985.
RAN TEST FOR 1985 TO VERIFY THAT THIS PROCEDURE REPLICATES jfdstmpa
***********************************************************************;

*%INCLUDE "~/jim/gzipseq.mcr"; 
LIBNAME mydat '~/jim/data';

*******  FAMILY FILES   **********;
 
filename inc841 pipe 'gunzip -c ~/jim/data/ce_itab/1984/08671-0004-Data.txt.gz';
filename inc842 pipe 'gunzip -c ~/jim/data/ce_itab/1984/08671-0008-Data.txt.gz';
filename inc843 pipe 'gunzip -c ~/jim/data/ce_itab/1984/08671-0012-Data.txt.gz';
filename inc844 pipe 'gunzip -c ~/jim/data/ce_itab/1984/08671-0016-Data.txt.gz';
 
%MACRO read(qyr);
 
  DATA itab&qyr;
   INFILE inc&qyr ;
   INPUT newid 1-8 ucc 13-18 cost 20-31;

 IF ucc=900150;

   qyear=&qyr;
   newid=9000000+newid;
  RUN;
 
PROC SORT; 
   BY newid;
RUN; 
PROC MEANS DATA=itab&qyr SUM NOPRINT; 
     BY newid;
     WHERE ucc=900150;
     VAR cost;
     OUTPUT OUT=out_r&qyr(DROP=_TYPE_ _FREQ_) SUM=tot_fstamp;
RUN;
PROC MEANS; 
RUN;

%MEND read;
 
%read(841);
%read(842);
%read(843);
%read(844);

DATA mydat.fix_fstamp84;
   SET out_r841 out_r842 out_r843 out_r844;

tot_fstamp2=tot_fstamp*4;

RUN;

PROC MEANS; 
RUN ;

PROC SORT; 
   BY newid;
RUN; 


*%gzipsq(work,fix_fstamp84,~/jim/data);   

ENDSAS;
*%gunzipsq(~/jim/data,famstep1,qyear newid jfdstmpa,qyear LE 855 AND qyear GE 851); 

PROC MEANS DATA=mydat.famstep1;
WHERE jfdstmpa GT 0; 
RUN ;

